﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#pragma hide=1

Static StrConstant k_fullpackageFolder = "root:Packages:imgT"
Static StrConstant k_fullpanel = "imgT_display#imgT_panel"
Static StrConstant k_imgDisplay = "imgT_display"

Function disp_Tab3Draw(pwidth,pheight,ptabpos)
	variable pwidth, pheight, ptabpos

	DFREF pf = $k_fullpackageFolder
	wave/SDFR=pf scalewx, scalewy

	variable tvoffset = ptabpos+30
	
	TabControl tab_main, value=3, userdata(ptab)="3"
	
	TitleBox layout_tab3,pos={12,tvoffset},size={84,22},title="Image"
	TitleBox layout_tab3,fSize=16,frame=0,fStyle=1,disable=1
	
	tvoffset += 24
	
	CheckBox checkShowAxes_tab3, pos={20,tvoffset},size={20,20},title="Axes"
	CheckBox checkShowAxes_tab3 value=1,proc=X_CheckProc,disable=1,help={"Show or hide axes on image."}
	
	PopupMenu popupScaleBar_tab3, pos={80,tvoffset-2},size={80,20},title="Scale Bar"
	PopupMenu popupScaleBar_tab3, mode=1, value="None;manual;⎡;⎣;⎤;⎦;", proc=X_PopMenuProc, disable=1

	PopupMenu popupSBColor_tab3, pos={210,tvoffset-2}, title="Color", disable=1
	PopupMenu popupSBColor_tab3, value="*COLORPOP*",proc=X_PopMenuProc,popColor=(0,0,0)
	
	Button buttonRedoColor_tab3, pos={pwidth-60,tvoffset-8},size={50,25},fSize=10,title="Refresh"
	Button buttonRedoColor_tab3,proc=X_ButtonProc,disable=1
	
	tvoffset += 20

	SetVariable setvarSBx_tab3,pos={60,tvoffset},title="x",size={80,20},format="%3.1f"
	SetVariable setvarSBx_tab3,value=scalewx[0],disable=1, proc=X_SetVarProc

	SetVariable setvarSBy_tab3,pos={160,tvoffset},title="y",size={80,20},format="%3.1f"
	SetVariable setvarSBy_tab3,value=scalewy[0],disable=1, proc=X_SetVarProc
	
	tvoffset += 36
	
	TitleBox cprint_tab3,pos={12,tvoffset},size={84,22},title="Layout"
	TitleBox cprint_tab3,fSize=16,frame=0,fStyle=1, disable=1
	
	ValDisplay valdispccp_tab3, pos={210,tvoffset+4}, title="prints for layout"
	ValDisplay valdispccp_tab3 size={100,20},value=_NUM:0, disable=1
	
	Button buttonClearAll_tab3, pos={pwidth - 90,tvoffset},size={80,22},title="Clear List"
	Button buttonClearAll_tab3, proc=X_ButtonProc,disable=1
	
	tvoffset += 24
	
	CheckBox checkCP_tab3,pos={20,tvoffset+4},size={20,20},fSize=14,title="include(d)"
	CheckBox checkCP_tab3,value=0,proc=X_CheckProc,disable=1,help={"Include this image for the layout.\rOr marked as included."}
	
	CheckBox checkdynamic_tab3 pos={120,tvoffset+4},size={20,20},title="dynamic"
	CheckBox checkdynamic_tab3 value=1,proc=X_CheckProc,disable=1,help={"Update images as best possible with any changes.\rOtherwise images are set and locked when added."}

	CheckBox checkwithtag_tab3,pos={pwidth-140,tvoffset+4},size={20,20},title="as contact print"
	CheckBox checkwithtag_tab3,value=0,proc=X_CheckProc,disable=1,help={"Contact print layout includes tags and notes.\rOtherwise layout shows just images."}

	tvoffset += 24
	
	SetVariable setvarCPNote_tab3,pos={12,tvoffset+5},title="Notes",size={240,20}
	SetVariable setvarCPNote_tab3,value=_STR:"",disable=1,help={"Put a note on the contact print layout."}
	
	Button buttonDoCPrint_tab3, pos={pwidth-140,tvoffset},size={110,25},title="Make Layout"
	Button buttonDoCPrint_tab3,proc=X_ButtonProc,disable=1

	return 0
end

Function disp_UpdateTab3()
	
	Button buttonRedoColor_tab3, win=$k_fullpanel, disable=0
	PopupMenu popupSBColor_tab3, win=$k_fullpanel, disable=0
	ControlInfo/W=$k_fullpanel popupScaleBar_tab3	
	switch(v_value)
		case 2:
			SetVariable setvarSBx_tab3, win=$k_fullpanel, disable=0
			SetVariable setvarSBy_tab3, win=$k_fullpanel, disable=0
			break
		case 1:
			Button buttonRedoColor_tab3, win=$k_fullpanel, disable=2
			PopupMenu popupSBColor_tab3, win=$k_fullpanel, disable=2
		default:
			SetVariable setvarSBx_tab3, win=$k_fullpanel, disable=1
			SetVariable setvarSBy_tab3, win=$k_fullpanel, disable=1
			break
	endswitch
	
	CheckBox checkwithtag_tab3, win=$k_fullpanel, disable=0
	CheckBox checkdynamic_tab3, win=$k_fullpanel, disable=0
	CheckBox checkCP_tab3, win=$k_fullpanel, value=f_IsContactPrint()
	ValDisplay valdispccp_tab3, win=$k_fullpanel, value=_NUM:f_CountofContactPrints()
	if (f_CountofContactPrints()>0)
		Button buttonDoCPrint_tab3, win=$k_fullpanel, disable=0
		Button buttonClearAll_tab3, win=$k_fullpanel, disable=0
	else
		Button buttonDoCPrint_tab3, win=$k_fullpanel, disable=2
		Button buttonClearAll_tab3, win=$k_fullpanel, disable=2
	endif
	
	return 0
end

// remove a contact print recreaction string
Function T3_ClearAllContactPrintImages()
	
	DFREF cpf = $k_fullpackageFolder + ":contactprint"
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	// global values
	if (!DataFolderExists(k_fullpackageFolder + ":contactprint"))
		return 0
	endif

	variable ic, npts
	string wStr
	
	npts = CountObjectsDFR(cpf,3)
	
	for (ic=0;ic<npts;ic+=1)
		wStr = GetIndexedObjNameDFR(cpf,3,ic)
		KillWindow/Z $wStr
	endfor
	
	KillDataFolder/Z cpf
	DFREF cdf = GetDataFolderDFR()
	SetDataFolder pf
	NewDataFolder/O contactprint
	SetDataFolder cdf

//	
//	Checkbox checkCP_tab3, win=$k_fullpanel, value=0
//	ValDisplay valdispccp_tab3, win=$k_fullpanel, value = 0
//	
//	Button buttonDoCPrint_tab3, win=$k_fullpanel, disable=2
//	Button buttonClearAll_tab3, win=$k_fullpanel, disable=2
	
//	SetVariable setvarCPNote_tab3, win=$k_fullpanel, disable=2
	return 0
end

// remove a contact print recreaction string
Function T3_RemoveContactPrint()

	// global values
	DFREF cpf = $k_fullpackageFolder + ":contactprint"
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string cpstr
	cpstr = cwdfolder[5,inf] + "_" + cwfile
	if (f_IsStack())
		sprintf cpstr "%s_%d", cpstr, f_PlaneNumber()
	endif

	DFREF cdf = GetDataFolderDFR()
	SetDataFolder cpf
	killstrings/Z $cpstr
	killwindow/Z $cpstr
	
	SetDataFolder cdf

	return 0
end

// store as contact print recreaction
Function T3_StoreasContactPrint() //[sfolder,sfile])
	string sfolder, sfile

	// global values
	DFREF cpf = $k_fullpackageFolder + ":contactprint"
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	DFREF cdf = GetDataFolderDFR()

	// tagged and scale bar?
	variable ctag, cscalebar	
	ControlInfo/W=$k_fullpanel checkwithtag_tab3
	ctag = v_value
	ControlInfo/W=$k_fullpanel popupScaleBar_tab3
	cscalebar = v_value

	// displayed image name
	string wname
	wname = f_DisplayImageID(3)
	
	SetDataFolder pf
	NewDataFolder/O/S contactprint
	
	// image to display
	string cpstrng
	cpstrng = cwdfolder[5,inf] + "_" + cwfile
	if (f_isStack())
		cpstrng += "_" + num2str(f_PlaneNumber())
	endif
	
	// full recreation for window and any window notes
	string cprec, scprec, eistr
	cprec = WinRecreation(k_imgDisplay,0)
	eistr = note($wname)
	
	// split the Control Bar from the window recreation
	string rgex = "((?s)(.)+)\\tControlBar 50"
	SplitString/E=(rgex) cprec, scprec
	
	// put the remaining lines into a text wave
	variable nlines, ic
	nlines = ItemsInList(scprec,"\t")
	make/N=(nlines)/T/FREE nWRw
	nWRw = StringFromList(p,scprec,"\t")
	
	// remove the starting lines
	string nWR, imgTscalex, imgTscaley, imgTscalebar
	if (cscalebar == 1)
		DeletePoints 0,5,nWRw
		nWR = "Display;"
	else
		DeletePoints 0,7, nWRw
		nWRw[0] = ReplaceString(":::",nWRw[0],":")
		imgTscalex = k_fullpackageFolder + ":scalewx"
		imgTscaley = k_fullpackageFolder + ":scalewy"
		imgTscalebar = imgTscaley + " vs " + imgTscalex + ";"
		nWR = "Display/T " + imgTscalebar
	endif
	nlines = DimSize(nWRw,0)
	for (ic=0;ic<nlines;ic+=1)
		nWR += RemoveEnding(nWRw[ic],"\r") + ";"
	endfor
	if (cscalebar != 1)
		nWR = RemoveFromList("SetDataFolder fldrSav0",nWR)
	endif
	nWR =  ReplaceString(",width={Plan,1,top,left}",nWR,"")

	string sstr
	sstr = "ModifyGraph expand=0.5,lsize=1, height={Plan,1,left,top};"
	if (ctag == 1)
		sstr += "TextBox/C/N=Tag/F=0/A=LT \"\\Z08" + cpstrng + "\";"
		if (strlen(eistr)!=0)
			sstr += "TextBox/C/N=ImgInfo/F=0/A=RB/X=0/Y=0 " + "\"\\Z08" + eistr +  "\";"
		endif
	endif
	nWR += sstr

	string/G $cpstrng = nWR
	
	SetDataFolder cdf
	
	return 0
end

// update current image as contact print
Function T3_UpdateContactPrint()

	if (f_IsContactPrint() && f_LayoutIsDynamic())
		T3_StoreasContactPrint()
	endif
	
	return 0
	
end

// turn on/off axes
Function disp_ShowAxes(onoff)
	variable onoff
	
	switch(onoff)
		case 0:		// off
			ModifyGraph nticks(top)=0, nticks(left)=0
			break
		case 1:
			ModifyGraph nticks(top)=12, nticks(left)=12
			break
	endswitch
	return 0
end

// set scale bar
// how = 0 to remove
// how = 1 for manual mode positioning
// all others are specific positions
Function disp_ShowScaleBar(variable how)
	
	DFREF pf = $k_fullpackageFolder
	wave/SDFR=pf/Z scalewx, scalewy, scaledx
	
	variable iscale, mpp, sp, scdwo, scdw
	variable idx, idy, idxoffset=0, idyoffset=0
	variable idwidth, idheight
	string tstr, sbcolor

	// clear the current scale bar
	
	Tag/K/N=sctag/W=$k_imgdisplay
	RemoveFromGraph/W=$k_imgDisplay/Z scalewy
	
	// leave if no scale bar to display
	
	if (how == 0)
		return 0
	endif
	
	// ** show a scale bar
	
	ControlInfo/W=$k_fullpanel popupSBColor_tab3
	sbcolor = S_value
#ifdef WINDOWS
	tstr = "\\Z18\\K" + sbcolor
#else
	tstr = "\\Z24\\K" + sbcolor
#endif
	
	// get image scale settings
	
	iscale = f_ImageSize()[0]	// how scaled (none, pixel, width, height)
	mpp = f_ImageSize()[5]		// meters per pixel
	
	// marker wave position is in graph coordinates!
	// get axis scaling to set offsets
	
	idxoffset = f_ImageSize()[7] // min(v_max,v_min)
	idyoffset = f_ImageSize()[8] // min(v_max,v_min)
	GetAxis/W=$k_imgDisplay/Q left
	idheight = abs(v_max - v_min)
	GetAxis/W=$k_imgDisplay/Q top
	idwidth = abs(v_max - v_min)
	
	// 10% of image height (pixels) rounded down

	sp = floor(log(idheight)) - 1
	idy = 10^sp
	
	// determine best settings for scale bar width
	
	switch(iscale)
		case 0:		// no scale (use pixels)
			// 10% of image width or height (pixels) rounded down
			sp = floor(log(idwidth)) - 1
			idx = 10^sp
			scaledx = idx/2
			sprintf tstr, "%s%d px", tstr, idx
			break
		default:		// scale in meters
			// 10% of image width pixels not rounded
			idx = 0.1*idwidth
			// round scale bar meters to report to one sig fig
			scdwo = mpp*idx
			sp = floor(log(scdwo))
			scdw = 10^sp*round(scdwo/10^sp)
			// calculate new scale bar pixel length
			idx *= (scdw/scdwo)
			scaledx = idx/2
			
			// set the scale levels
			
			sp = floor(log(scdw))

			switch(sp)
				case -9:
				case -8:
				case -7:
					sprintf tstr, "%s%3.0f nm", tstr, scdw*10^(9)
					break
				case -6:
				case -5:
				case -4:
					sprintf tstr, "%s%3.0f um", tstr, scdw*10^(6)
					break
				case -3:
					sprintf tstr, "%s%3.0f mm", tstr, scdw*10^(3)
					break
				case -2:
				case -1:
					sprintf tstr, "%s%3.0f cm", tstr, scdw*10^(2)
					break
				case 0:
				case 1:
				case 2:
					sprintf tstr, "%s%3.0f m", tstr, scdw
					break
				case 3:
				case 4:
				case 5:
					sprintf tstr, "%s%3.0f km", tstr, scdw/10^(3)
					break
				case 6:
				case 7:
				case 8:
					sprintf tstr, "%s%3.0f Mm", tstr, scdw/10^(6)
					break
				default:
					sprintf tstr, "%s%3.2g m", tstr, scdw
					break
			endswitch
			break
	endswitch
	
	switch(how)
		case 1:		// manual
			if (numtype(scalewx[0]) == 2)
				scalewx = idxoffset + scaledx + idx
				scalewy = idyoffset + 1.5*idy
			endif
			break
		case 2:		// on LT
			scalewx = idxoffset + scaledx + idx
			scalewy = idyoffset + 1.5*idy
			break
		case 3:		// on LB
			scalewx = idxoffset + scaledx + idx
			scalewy = (idyoffset + idheight) - 1*idy
			break
		case 4:		// on RT
			scalewx = (idxoffset +idwidth) - (idx + scaledx)
			scalewy = idyoffset + 1.5*idy
			break
		case 5:		// on RB
			scalewx = (idxoffset +idwidth) - (idx + scaledx)
			scalewy = (idyoffset + idheight) - 1*idy
			break
	endswitch

	// add scale bar
	
	AppendToGraph/W=$k_imgDisplay/T scalewy vs scalewx
	ModifyGraph/W=$k_imgDisplay mode=2
	DoUpdate/W=$k_imgDisplay
	ErrorBars/L=3/W=$k_imgDisplay scalewy, X, wave=(scaledx,scaledx)
	Tag/C/N=sctag/F=0/A=MB/L=0/B=1/X=0/Y=1/W=$k_imgdisplay scalewy, 0,tstr
	disp_SetScaleBarColor(sbcolor)

	return 0
end

// change scale bar color
Function disp_SetScaleBarColor(cstr)
	string cstr

	DFREF pf = $k_fullpackageFolder
	wave/SDFR=pf scalewx, scalewy, scaledx

	string tstr, estr = "(.+)(\\K.+\))(.+)", zstr, kstr,fstr

	// no scale bar on graph
	if (strlen(AnnotationList(k_imgDisplay)) == 0)
		scalewx = NaN
		scalewy = NaN
		scaledx = NaN
		return -1
	endif
	
	tstr = AnnotationInfo(k_imgDisplay,"sctag",0)
	tstr = StringFromList(ItemsInList(tstr)-1,tstr)
	SplitString/E=estr tstr[5,inf], zstr,kstr,fstr
	
	tstr = "\Z24\K" + cstr + fstr
	
	Tag/C/N=sctag/W=$k_imgDisplay tstr
	
	ControlInfo/W=$k_fullpanel popupSBColor_tab3
	//disp_SetScaleBarColor(S_value)	
	ModifyGraph/W=$k_imgDisplay rgb(scalewy)=(V_red,V_green,V_blue)

	return 0	
end

// ***
// Contact Prints

// generate contact print layout
Function T3_CreateContactPrintLayout()

	// global values
	DFREF cpf = $k_fullpackageFolder + ":contactprint"
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable cntp, ic, ip, pc, wsize, withtags
	string strName,fulllist="",porl,tilestr,eistr, sCmd
	
	ControlInfo/W=$k_fullpanel checkwithtag_tab3
	withtags = v_value
	
	cntp = f_CountofContactPrints()
	
	if (cntp<=0)
		DoAlert/T="Contact Print", 0, "No images stored as contact prints."
		return 0
	endif

	if (cntp < 3)
		wsize = 8*72/cntp
		porl = "LANDSCAPE"
		tilestr = "Tile/A=(0,2)"
	elseif (cntp < 5)
		wsize = 1.5*8*72/cntp
		porl = "PORTRAIT"
		tilestr = "Tile/A=(0,2)"
	elseif (cntp < 9)
		wsize = 1.5*10.5*72/cntp
		porl = "LANDSCAPE"
		tilestr = "Tile/A=(2,0)"
	elseif (cntp < 12)
		wsize = 1.5*10.5*72/cntp
		porl = "LANDSCAPE"
		tilestr = "Tile/A=(3,0)"
	else
		wsize = 10.5*72/cntp
		porl = "LANDSCAPE"
		tilestr = "Tile/A=(3,0)"
	endif
	
	for (ic=0;ic<cntp;ic+=1)
		strName = GetIndexedObjNameDFR(cpf,3,ic)
		fulllist += strName + ";"
		DoWindow/K/Z $strName
		SVAR/SDFR=cpf exCmd = $strName
//		if (!withtags)
//			sCmd = RemoveListItem(ItemsInList(exCmd)-1,exCmd)
//		else
//			sCmd = exCmd
//		endif
		Execute/Q/Z exCmd
		DoWindow/C $strName
		ModifyGraph/W=$strname width=wsize
		ModifyGraph/W=$strname width=0
		DoWindow/HIDE=1 $strName
	endfor
	
	fullList = SortList(fullList)
	
	DoWindow/K/Z imgT_contactlayout
	NewLayout/P=$porl/N=imgT_contactlayout
	for (ic=0;ic<cntp;ic+=1)
		strName = StringFromList(ic,fulllist)
		AppendLayoutObject/F=0 graph $strName
	endfor
	Execute/Q/Z tilestr
	
	if (withtags)
		// add info to display
		eistr = f_DateTimeStamp() + " " + IgorInfo(1) + " " + IgorInfo(7)
		ControlInfo/W=$k_fullpanel setvarCPNote_tab3
		if (strlen(s_value)!=0)
			eistr += "\t" + s_value
		endif
		TextBox/C/N=ExpInfo/F=0/A=RB/X=0/Y=0 eistr
	endif
	DoUpdate/W=imgT_contactLayout
	DoWindow/F imgT_contactlayout
	return 0
end
